package klasy;

/**
 * <p>Title: Ulamek</p>
 * <p>Description: Przykladowa klasa Ulamek</p>
 * <p>Copyright: Copyright (c) Jacek Matulewski 2003</p>
 * <p>Company: </p>
 * @author unascribed
 * @version 1.0
 */

public class Ulamek implements Cloneable
{
  private int licznik,mianownik;

  public Ulamek(int alicznik,int amianownik)
    throws Exception
    {
    try
      {
      set(alicznik,amianownik);
      }
    catch(Exception E)
      {
      throw E;
      }
    }

  public Object clone()
    throws CloneNotSupportedException
    {
    Object wynik=null;
    try
      {
      wynik=super.clone();
      }
    catch(CloneNotSupportedException E)
      {
      throw E;
      }
    return wynik;
    }

  public void set(int alicznik,int amianownik)
    throws Exception
    {
    if (amianownik==0) throw new Exception("Ulamek: Blad #1");
    licznik=alicznik;
    mianownik=amianownik;
    }

  public void get(int[] arg)
    {
    arg[0]=licznik;
    arg[1]=mianownik;
    }

  public int[] get()
    {
    int[] wynik=new int[2];
    wynik[0]=licznik;
    wynik[1]=mianownik;
    return wynik;
    }

  public static Ulamek Prod(Ulamek aulamek1,Ulamek aulamek2)
    throws Exception
    {
    int[] alicznik1_amianownik1=aulamek1.get();
    int[] alicznik2_amianownik2=aulamek2.get();
    Ulamek wynik=null;
    try
      {
      wynik=new Ulamek(alicznik1_amianownik1[0]*alicznik2_amianownik2[0],alicznik1_amianownik1[1]*alicznik2_amianownik2[1]);
      }
    catch(Exception E) {throw E;}
    return wynik;
    }

  public static Ulamek Quot(Ulamek aulamek1,Ulamek aulamek2)
    throws Exception
    {
    int[] alicznik1_amianownik1=aulamek1.get();
    int[] alicznik2_amianownik2=aulamek2.get();
    Ulamek wynik=null;
    try
      {
      wynik=new Ulamek(alicznik1_amianownik1[0]*alicznik2_amianownik2[1],alicznik1_amianownik1[1]*alicznik2_amianownik2[0]);
      }
    catch(Exception E) {throw E;}
    return wynik;
    }

  public static Ulamek Sum(Ulamek aulamek1,Ulamek aulamek2)
    throws Exception
    {
    int[] alicznik1_amianownik1=aulamek1.get();
    int[] alicznik2_amianownik2=aulamek2.get();
    Ulamek wynik=null;
    try
      {
      wynik=new Ulamek(alicznik1_amianownik1[0]*alicznik2_amianownik2[1]+alicznik1_amianownik1[1]*alicznik2_amianownik2[0],alicznik1_amianownik1[1]*alicznik2_amianownik2[1]);
      }
    catch(Exception E) {throw E;}
    return wynik;
    }

  public static Ulamek Revr(Ulamek aulamek1)
    throws Exception
    {
    int[] alicznik1_amianownik1=aulamek1.get();
    Ulamek wynik=null;
    try
      {
      wynik=new Ulamek(-alicznik1_amianownik1[0],alicznik1_amianownik1[1]);
      }
    catch(Exception E) {throw E;}
    return wynik;
    }

  public static Ulamek Diff(Ulamek aulamek1,Ulamek aulamek2)
    throws Exception
    {
    int[] alicznik1_amianownik1=aulamek1.get();
    int[] alicznik2_amianownik2=aulamek2.get();
    Ulamek wynik=null;
    try
      {
      wynik=new Ulamek(alicznik1_amianownik1[0]*alicznik2_amianownik2[1]-alicznik1_amianownik1[1]*alicznik2_amianownik2[0],alicznik1_amianownik1[1]*alicznik2_amianownik2[1]);
      }
    catch(Exception E) {throw E;}
    return wynik;
    }

  /* porownanie <, >, = */
  public static int Cmp(Ulamek aulamek1,Ulamek aulamek2)
    {
    int[] alicznik1_amianownik1=aulamek1.get();
    int[] alicznik2_amianownik2=aulamek2.get();
    double wynik=(alicznik1_amianownik1[0]/(double)alicznik1_amianownik1[1])-(alicznik2_amianownik2[0]/(double)alicznik2_amianownik2[1]);
    byte int_wynik;
    if (wynik==0) int_wynik=(byte)(wynik); else int_wynik=(byte)(wynik/Math.abs(wynik));
    return int_wynik;
    }

  public double toDouble()
    {
    return licznik/(double)mianownik;
    }

  //nadpisana na Object.toString
  public String toString()
    {
    return String.valueOf(licznik)+"/"+String.valueOf(mianownik);
    }
}

